.plugin asm86
#include "RBP2.inc" ; The necessary header file

.org $D748    ; Where to start program in memory

 res $05,(iy+$00)   ; turns off "Done" after program finishes
 call _clrLCD ; Clears homescreen
 ld hl,Hello  ; Load 16-bit register hl to data Hello
 ld de,$0000  ; Load 16-bit register de with hex values, (d,e) = (0,0)
 push hl      ; save hl to the stack
 push hl      ; again, making the stack hl,hl
 push hl      ; save hl to the stack (stack = hl,hl,hl)
 call BigText ; call the sub-routine that displays large text
              ; pop stores to a 16-bit value, useful after a sub-routine changes them
 pop hl       ; take hl off the stack, leaving hl,hl
 ld de,$1F2F  ; Load 16-bit register de with hex values, (d,e) = (31,47)
 call SmallText ; call the sub-routine that displays small text
 call Inverse ; call the sub-routine that inverses text
 pop hl       ; take hl off the stack, leaving only hl
 ld de,$0806  ; Load 16-bit register de with hex values, (d,e) = (6,8)
 push de      ; save de to the stack (stack = de,hl)
 call SmallText ; call the sub-routine that displays small text
 pop de       ; take de off the stack, leaving only hl
 pop hl       ; take hl off the stack, leaving the stack empty
              ; having something pushed on the stack usually crashes the TI-86 when the TI-OS
              ; takes over; same thing if you pop too much off.
 call BigText ; call the sub-routine that displays big text
 jp Inverse   ; inverse text again, back to normal, and exit program

BigText:         ; a label, BigText
 ld (_curRow),de ; Load _curRow as d, and _curCol as e
 jp _puts        ; Displays data at hl to screen, at coordinates (_curRow,_curCol)

SmallText:       ; a label, SmallText
 ld (_penCol),de ; Load _penCol as d, and _penRow as e
 jp _vputs       ; Displays data at hl to screen, at coordinates (_penCol,_penRow)

Inverse:          ; a label, Inverse
 bit $03,(iy+$05) ; check if text is inverted
 jr nz,Reset      ; if so, fix it to normal colors
 set $03,(iy+$05) ; invert it
 ret              ; return from sub-routine
Reset:            ; a label, Reset
 res $03,(iy+$05) ; reset text to normal colors
 ret              ; return from sub-routine

Hello:               ; a label, Hello
.db "Hello, World",0 ; Data - 13 bytes ending with 0 (zero terminated)

.end       ; End Directive, end of code