.plugin asm86
#include "RBP2.inc"

.org $D748
 
 call _clrLCD  ; clears the screen
 ld hl,$FF90   ; near the bottom of the screen
 ; this is where we copy from
 ; you must understand, the screen is a bitmap loaded from $FC00-$FFFF,
 ; so, any value in that range can be changed for graphics.
 push hl ; save hl to stack
 pop de  ; retore it to de
 inc de  ; de now = hl+1
 ld bc,112     ; how many bytes to copy over
 ld (hl),$FF   ; setting the value
 ldir          ; copy it already
 call _runindicoff ; turn off that busy indicator (located in the top right corner)
 set 3,(iy+5)  ; inverted text colors
 ld hl,Menu    ; point 16-bit register hl to Menu (text data)
 ld de,$3900   ; load 16-bit register de with $3900
 call PutSmall ; display small text
 ld e,30       ; load 8-bit register e with 30
 call PutSmall ; display small text
 ld e,60       ; load 8-bit register e with 60
 call PutSmall ; display small text
 ld e,120      ; load 8-bit register e with 120
 call PutSmall ; display small text
KeyLup:       ; label KeyLup. plz, I DO know how to spell, so no emails
 call _getkey ; gets key press and stores to 8-bit register a
 cp kF1       ; did you press F1 (sort-of a TI-Basic If..Then)
 jr z,NoGame  ; exit if you did (z is 'true')
 cp kF2       ; did you press F2
 jr z,Invert  ; exit if you did (z is 'true')
 cp kF3       ; did you press F3
 jr z,Scroll  ; exit if you did (z is 'true')
 cp kF5       ; did you press F5
 jr nz,KeyLup ; if no function key was pressed start over (nz is 'false')
Quit:         ; label Quit
 res 3,(iy+5) ; normal text colors
 res 5,(iy+0) ; no "Done" when exited
 call _clrLCD ; guess! i've decided to save space by not re-explaining
; every call used, but I will try to thoroughly explain every routine
 jp _homeUp  ; puts the cursor at the top left corner of the screen
 
Scroll:       ; this routine will be lazily commented, which is normal
 res 3,(iy+5) ; normal text colors
 ld hl,Wow    ; point to the text
 ld de,$0000  ; set coordinates for text
 ld b,40      ; setup 40 loops
Sloop1:       ; if you don't know, go play with your lego's
 call SaveText ; run sub-routine to display text, while saving hl
 inc e        ; increase vertical coord
 inc d        ; increase horizontal coord
 djnz Sloop1  ; decrease b and loop until b=0
 ld b,40      ; setup 40 loops
Sloop2:
 call SaveText ; run sub-routine to display text, while saving hl
 inc e        ; increase vertical coord
 dec d        ; decrease horizontal coord
 djnz Sloop2  ; decrease b and loop until b=0
 jr KeyLup    ; go back to reading keypresses

SaveText: ; a 5 byte sub-routine
 push hl ; save hl to the stack
 call PutSmall ; run the sub-routine to display small text
 pop hl  ; restore hl from stack, because _vputs changes it
 ret     ; return (this is exit)  - last time commented
 
Invert:
 ld hl,$FC00  ; screen
 ld de,1024   ; bytes on screen, for loop counter
InvLp:
 ld a,(hl)    ; load accumulator with byte from hl
 cpl          ; invert it
 ld (hl),a    ; load the byte back to the screen
 dec de       ; decrease loop counter
 inc hl       ; go to next screen byte
 ld a,d       ; load 8-bit register with 8-bit register d (a=d)
 or e         ; is 8-bit register e zero? if so, then the accumulator
; (register a) also is 0. since a=d, and if a=e, then d=e=0 & the counter
; is at 0 because de=$0000...
 jr nz,InvLp ; if de isn't $0000, keep looping
 jr KeyLup   ; go back to readking keypresses
 
NoGame:
 ld hl,Play   ; point the some text
 ld de,$0000  ; set both 8-bit registers d and e as zero
 call PutSmall ; run the sub-routine for displaying small text
 jr KeyLup     ; run the exiting sub-routine
 
PutSmall:     ; label PutSmall
 ld (_penCol),de ; setup coordinates for small text
 jp _vputs       ; display the small text and return
; FYI: jp XXXX is the same as call XXXX \ ret

; Try keeping data at the end of your program.
Menu:
.db "Play",0,"Fun!",0,"Cool",0,"X",0
; display routines cut off text when it finds a zero
; so we can group text by putting a zero in between
; each string. here we have 5 strings for the menu,
; so, 5 zeros. it is also called zero terminated text
Play:
.db "Silliness",0
Wow:
.db "Scrolling Text",0

.end